/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class CounterTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    private boolean prevIn = false;
    private int counter = 1;
    @GuiValue
    public static final Value<CounterTileEntity, Integer> VALUE_COUNTER = Value.create((String)"counter", (Type)Type.INTEGER, CounterTileEntity::getCounter, CounterTileEntity::setCounter);
    @GuiValue
    private int current = 0;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Counter").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_COUNTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public CounterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.TYPE_COUNTER.get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/counter")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(CounterTileEntity::new));
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.m_6596_();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.m_6596_();
    }

    protected void update() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        int newout = 0;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = 15;
            }
            this.m_6596_();
            this.support.setRedstoneState((GenericTileEntity)this, newout);
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
        this.prevIn = tagCompound.m_128471_("prevIn");
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.counter = info.m_128451_("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = info.m_128451_("current");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
        tagCompound.m_128379_("prevIn", this.prevIn);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("counter", this.counter);
        info.m_128405_("current", this.current);
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
        this.update();
    }
}

